function Seg=Simulate03(nSeg, n, par)
disp('Simulation values:');
disp(par);
for i=1:nSeg
	disp(['Simulating Segment ' int2str(i) ' of ' int2str(nSeg)])
	dm = sqrt(par.varu)*randn(1,n);
	m = cumsum(dm);
	%	Simulate trade directions (20% will be set to zero).
	r = rand(1,n)-.5;	%	r is U(-0.5, +0.5)
	r = (abs(r)>.1) .* r;	%	Set 20% of the r's to zero
	Seg(i).q = sign(r);	% Pr(q=-1)=Pr(q=+1)=0.4, Pr(q=0)=0.2
	Seg(i).p = m + par.c * Seg(i).q;
	nBuy = sum(Seg(i).q==1);
	nSell = sum(Seg(i).q==-1);
	nMid = sum(Seg(i).q==0);
	disp([int2str(nBuy) ' buys; ' int2str(nSell) ' sells; ' int2str(nMid) ' Midpoints'])
end;